#include <stdint.h>

typedef float float32_t;
typedef _Bool bool_t;

void example ( void )
{
  float32_t f32a, f32b;
  int16_t   s16b;
  uint16_t  u16b;
  bool_t    bla,  blb;
  int8_t    s8a,  s8b;
  uint8_t   u8a,  u8b;
  char      cha,  chb;
  bool_t    bla,  blb;

/* ----------------- Example code from MISRA C:2012 begin ----------------- */

  enum enuma { a1, a2, a3 } ena, enb;
  enum { K1 = 1, K2 = 2 };

  f32a & 2U;        /* Non-compliant */
  f32a << 2;        /* Non-compliant */

  cha && bla;       /* Non-compliant */
  ena ? a1 : a2;    /* Non-compliant */
  s8a && bla;       /* Non-compliant */
  u8a ? a1 : a2;    /* Non-compliant */
  f32a && bla;      /* Non-compliant */

  bla * blb;        /* Non-compliant */
  bla > blb;        /* Non-compliant */

  cha & chb;        /* Non-compliant */
  cha << 1;         /* Non-compliant */

  ena--;            /* Non-compliant */
  ena * a1;         /* Non-compliant */

  s8a & 2;          /* Non-compliant */
  50 << 3U;         /* Non-compliant */

  u8a << s8a;       /* Non-compliant */
  u8a << -1;        /* Non-compliant */

  -u8a;             /* Non-compliant */

  ena += a1;        /* Non-compliant */

  bla && blb;       /* Compliant     */
  bla ? u8a : u8b;  /* Compliant     */

  cha - chb;        /* Compliant     */
  cha > chb;        /* Compliant     */

  ena > a1;         /* Compliant     */
  K1 * s8a;         /* Compliant     */

  s8a + s16b;       /* Compliant     */
  -( s8a ) * s8b;   /* Compliant     */
  s8a > 0;          /* Compliant     */
  --s16b;           /* Compliant     */

  u8a + u16b;       /* Compliant     */
  u8a & 2U;         /* Compliant     */

  u8a > 0U;         /* Compliant     */
  u8a << 2U;        /* Compliant     */
  u8a << 1;         /* Compliant     */

  f32a + f32b;      /* Compliant     */
  f32a > 0.0;       /* Compliant     */

  cha + chb;        /* Compliant     */

/* ------------------ Example code from MISRA C:2012 end ------------------ */
}
